if(!NU){var NU={};}
NU.refl={
    "version":"Time-stamp: <2014-06-17 09:16:16 nous>",
    "publ":{"clas":{},"func":{},"cons":{}},
    "priv":{"clas":{},"func":{},"cons":{}}
};


NU.refl.publ.cons.SVGNS="http://www.w3.org/2000/svg";
NU.refl.publ.cons.XLINKNS="http://www.w3.org/1999/xlink";

NU.refl.publ.func.createAndPut = function(pare,ctrlbox,imghrefs){
    var imageboard=new NU.refl.priv.clas.ImageBoard("15.6cm","15.6cm",
					imghrefs);
    pare.appendChild(imageboard.getImageElement());    
    ctrlbox.appendChild(imageboard.getControlElement());
};


/** */
NU.refl.priv.clas.ImageBoard = function(width,height,imghrefs){
    this.width=width;
    this.height=height;

    this.imghrefradio=[];
    this.svgelm=null;

    this.imgelm=document.createElement("div");
    this.imgelm.setAttribute("style","position:relative;");


    this.ctrlelm=document.createElement("form");
    this.ctrlelm.setAttribute("class","ctrlbox");
    var pare;
    pare=document.createElement("div");
    this.ctrlelm.appendChild(pare);
    pare.setAttribute("class","buttonbox");

    var elm;
    elm=document.createElement("input");
    pare.appendChild(elm);
    elm.setAttribute("type","button");
    elm.setAttribute("value","show");
    elm.addEventListener("click",
			 (function(imageboard){
			     return function(){imageboard.refleshSVG();}
			 })(this),
			 true);

    var pare,textnode;
    pare=document.createElement("div");
    this.ctrlelm.appendChild(pare);
    pare.setAttribute("class","selectgroup");

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode("Group: ");
    elm.appendChild(textnode);



    this.wpgtype=document.createElement("select");
    pare.appendChild(this.wpgtype);
    var i,j;
    var option;
    for(i=0;i<NU.refl.priv.cons.WPGTYPE.length;i++){
	for(j=0;j<NU.refl.priv.cons.WPGTYPE[i].length;j++){
	    option=document.createElement("option");
	    this.wpgtype.appendChild(option);
	    option.setAttribute("value",NU.refl.priv.cons.WPGTYPE[i][j]);
	    textnode=document.createTextNode(NU.refl.priv.cons.WPGTYPE[i][j]);
	    option.appendChild(textnode);
	}
    }


    pare=document.createElement("div");
    this.ctrlelm.appendChild(pare);
    pare.setAttribute("class","selectparameter");

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode("Unit size: ");
    elm.appendChild(textnode);

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode("width = ");
    elm.appendChild(textnode);


    this.wpgwidth=document.createElement("input");
    pare.appendChild(this.wpgwidth);
    this.wpgwidth.setAttribute("type","text");
    this.wpgwidth.setAttribute("value","140");
    this.wpgwidth.setAttribute("size","3");
    
    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(" (1=0.15mm) / ");
    elm.appendChild(textnode);

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(" height = ");
    elm.appendChild(textnode);

    this.wpgheight=document.createElement("input");
    pare.appendChild(this.wpgheight);
    this.wpgheight.setAttribute("type","text");
    this.wpgheight.setAttribute("value","120");
    this.wpgheight.setAttribute("size","3");


    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(" (1=0.15mm) / ");
    elm.appendChild(textnode);

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(" skew = ");
    elm.appendChild(textnode);

    this.wpgskew=document.createElement("input");
    pare.appendChild(this.wpgskew);
    this.wpgskew.setAttribute("type","text");
    this.wpgskew.setAttribute("value","0.3");
    this.wpgskew.setAttribute("size","3");

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(" (0%-100%) ");
    elm.appendChild(textnode);

    var typechangehandle = function(height,skew,sel){
	return function(event){
	    var i,type;
	    type=sel.options[sel.selectedIndex].value;
	    for(i=0;i<NU.refl.priv.cons.WPGTYPE[1].length;i++){
		if(NU.refl.priv.cons.WPGTYPE[1][i]==type){
		    height.disabled=true;
		    skew.disabled=true;
		}
	    }
	    for(i=0;i<NU.refl.priv.cons.WPGTYPE[2].length;i++){
		if(NU.refl.priv.cons.WPGTYPE[2][i]==type){
		    height.disabled=false;
		    skew.disabled=true;
		}
	    }
	    for(i=0;i<NU.refl.priv.cons.WPGTYPE[3].length;i++){
		if(NU.refl.priv.cons.WPGTYPE[3][i]==type){
		    height.disabled=false;
		    skew.disabled=false;
		}
	    }
	}
    };
    this.wpgtype.addEventListener("change",
				  typechangehandle(this.wpgheight,this.wpgskew,this.wpgtype),
				  false);
    typechangehandle(this.wpgheight,this.wpgskew,this.wpgtype)();




    pare=document.createElement("div");
    this.ctrlelm.appendChild(pare);
    pare.setAttribute("class","selectimage");
    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode("Select image");
    elm.appendChild(textnode);

    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(" (You can load local files: ");
    elm.appendChild(textnode);

    elm=document.createElement("input");
    pare.appendChild(elm);
    elm.setAttribute("type","file");
    elm.addEventListener( 'change',
			   (function(imageboard){
			       return function(evt){
				   var i;
				   for(i=0;i<evt.target.files.length;i++){
				       imageboard.loadfromfile(evt.target.files[i]);
				   }
			       }
			   })(this),
			   false
			 );


    elm=document.createElement("span");
    pare.appendChild(elm);
    textnode=document.createTextNode(") : ");
    elm.appendChild(textnode);

    this.imghrefbox=document.createElement("div");
    this.imghrefbox.setAttribute("class","imagebox");
    pare.appendChild(this.imghrefbox);
    var i;
    for(i=0;i<imghrefs.length;i++){
	this.appendImghrefOption(imghrefs[i]);
    }
};

NU.refl.priv.clas.ImageBoard.prototype = {
    getImageElement: function(){
	return this.imgelm;
    },
    refleshSVG: function(svgxml){
	var wpg;
	var wpgtype,wpgwidth,wpgheight,wpgskew;
	wpgheight=Number(this.wpgheight.value);
	wpgwidth=Number(this.wpgwidth.value);
	wpgskew=Number(this.wpgskew.value)/100;
	wpgtype=this.wpgtype.options[this.wpgtype.selectedIndex].value
	wpg=new NU.refl.priv.clas.WPG(wpgtype,wpgwidth,wpgheight,wpgskew);

	var imghref,i;
	for(i=0;i<this.imghrefradio.length;i++){
	    if(this.imghrefradio[i].checked){
		imghref=this.imghrefradio[i].value;
	    }
	}
	var svg=new NU.refl.priv.clas.BaseSVG(this.width,this.height,wpg,imghref);
	var svgxml=svg.getHtmlElement();
	if(this.svgelm){
	    this.imgelm.replaceChild(svgxml,this.svgelm);
	}else{
	    this.imgelm.appendChild(svgxml);
	}
	this.svgelm=svgxml;
    },

    getControlElement: function(){
	return this.ctrlelm;
    },

    appendImghrefOption: function(href){
	var name="imghref";
	var pare;
	pare=document.createElement("label");
	this.imghrefbox.appendChild(pare);
	pare.setAttribute("class","imageoption");

	elm=document.createElement("input");
	pare.appendChild(elm);
	this.imghrefradio[this.imghrefradio.length]=elm;
	elm.setAttribute("type","radio");
	elm.setAttribute("name",name);
	elm.setAttribute("value",href);
	elm.checked=true;

	
	var img;
	img=document.createElement("img");
	pare.appendChild(img);
	img.setAttribute("src",href);
	img.setAttribute("class", "image");
	
    },

    loadfromfile: function(file){
	if(!file.type.match('image.*')){
	    window.alert("Select image file.");
	    return;
	}
	var reader = new FileReader();
	reader.onload = ( function(imageboard){
	    return function(evt){
		imageboard.appendImghrefOption(evt.target.result);
	    };
	})(this);
	reader.readAsDataURL(file);
    }
};




/* *** */
NU.refl.priv.clas.BaseSVG = function(width,height,wpg,imagehref){

    this.svgimg=document.createElementNS(NU.refl.publ.cons.SVGNS, 'svg');
    this.svgimg.setAttribute("version","1.1");
    this.svgimg.setAttribute("width",width);
    this.svgimg.setAttribute("height",height);
    this.svgimg.setAttribute("viewBox","0 0 1000 1000");
    this.defs=document.createElementNS(NU.refl.publ.cons.SVGNS, 'defs');
    this.svgimg.appendChild(this.defs);
    this.g=document.createElementNS(NU.refl.publ.cons.SVGNS, 'g');
    this.svgimg.appendChild(this.g);
    var cp,p;
    cp=document.createElementNS(NU.refl.publ.cons.SVGNS, 'mask');
    this.defs.appendChild(cp);
    cp.setAttribute("id","cp");
    cp.setAttribute("maskUnits","objectBoundingBox");
    cp.setAttribute("x",0);
    cp.setAttribute("y",0);
    cp.setAttribute("width",1);
    cp.setAttribute("height",1);
    cp.setAttribute("maskContentUnits","objectBoundingBox");
    p=document.createElementNS(NU.refl.publ.cons.SVGNS, 'path');
    cp.appendChild(p);

    var fd=wpg.getFundamentalDomain();
    var fdstring="";
    var i;
    for(i=0;i<fd.length;i++){
	if(i==0){
	    fdstring=fdstring+"M ";
	}else{
	    fdstring=fdstring+"L ";
	}
	fdstring=fdstring+(fd[i][0])+" "+(fd[i][1])+" ";
    }
    fdstring=fdstring+"z";
    p.setAttribute("d",fdstring);
    p.setAttribute("fill","white");
    p.setAttribute("fill-rule","evenodd");
    var g,tt;
    g=document.createElementNS(NU.refl.publ.cons.SVGNS, 'g');
    this.defs.appendChild(g);
    g.setAttribute("id","base");
    g.setAttribute("mask","url(#cp)");


    tt=document.createElementNS(NU.refl.publ.cons.SVGNS, 'image');
    tt.setAttribute("x",-1);
    tt.setAttribute("y",-1);
    tt.setAttribute("width",wpg.width+2);
    tt.setAttribute("height",wpg.height+2);
//    tt.setAttribute("preserveAspectRatio","xMidYMid slice");
    tt.setAttribute("preserveAspectRatio","none");
//    tt.setAttribute("preserveAspectRatio","xMaxYMax slice");
    tt.setAttributeNS(NU.refl.publ.cons.XLINKNS,
		      "xlink:href",
		      imagehref);
    g.appendChild(tt);


    var t;
    t= new NU.refl.priv.clas.CellRegionImage("base",wpg.getCellStructure());
    var lis,i;
    lis=t.getUses();
    g=document.createElementNS(NU.refl.publ.cons.SVGNS, 'g');
    this.defs.appendChild(g);
    g.setAttribute("id","cell");
    for(i=0;i<lis.length;i++){
	g.appendChild(lis[i]);
    }

    var dd;
    dd = wpg.getCell();
    t = new NU.refl.priv.clas.PTCopiedImages("cell",dd[0],dd[1],dd[2],1000,1000);
    lis=t.getUses();
    for(i=0;i<lis.length;i++){
	this.g.appendChild(lis[i]);
    }

};

NU.refl.priv.clas.BaseSVG.prototype = {
    getHtmlElement: function(){
	return this.svgimg;
    },
};

NU.refl.priv.clas.CopiedImages = function(imgid){
    this.imgid=imgid;
}

NU.refl.priv.clas.CopiedImages.prototype = {
    getUses: function(){
	var t,r,i;
	r=[];
	t=this.getTranforms();
	for(i=0;i<t.length;i++){
	    r[i]=document.createElementNS(NU.refl.publ.cons.SVGNS, 'use');
	    r[i].setAttributeNS(NU.refl.publ.cons.XLINKNS,
			     "xlink:href",
			     "#"+this.imgid);
	    r[i].setAttribute("transform",t[i]);
	}
	return r;
    },
    getTranforms: function(){
	return [];
    },
    getMatrixString: function(m){
	var a11,a21,a12,a22,dx,dy;
	a11=m[0];
	a21=m[1];
	a12=m[2];
	a22=m[3];
	dx=m[4];
	dy=m[5];
	return "matrix("+a11+","+a21+","+a12+","+a22+","+dx+","+dy+")";
    },
};


/** */
NU.refl.priv.clas.PTCopiedImages = function(imgid,dx,dxr,dyr,w,h){
    NU.refl.priv.clas.CopiedImages.apply(this, arguments);
    if(dx>0){
	this.dx=dx;
    }else{
	this.dx=-dx;
    }
    if(dyr>0){
	this.dxr=dxr;
	this.dyr=dyr;
    }else{
	this.dxr=-dxr;
	this.dyr=-dyr;
    }
    this.w=w;
    this.h=h;
};
NU.refl.priv.clas.PTCopiedImages.prototype = new NU.refl.priv.clas.CopiedImages();
NU.refl.priv.clas.PTCopiedImages.prototype.getLatticePoints=function(){
    var i,r,x,y;
    r=[]; 
    x=-this.dxr;
    y=-this.dyr;
    while(y<=this.h+2*this.dyr){
	while(x>=0){
	    x=x-this.dx;
	}
	while(x<this.w+2*this.dx){
	    r[r.length]=[x,y];
	    x=x+this.dx;
	}
	x=x+this.dxr;
	y=y+this.dyr;
    }
    return r;
};
NU.refl.priv.clas.PTCopiedImages.prototype.getTranforms=function(){
    var r,l,i;
    r=[];
    l=this.getLatticePoints();
    for(i=0;i<l.length;i++){
	r[i]=this.getMatrixString([1,0,0,1,l[i][0],l[i][1]]);
    }
    return r;
}

/** */
NU.refl.priv.clas.CellRegionImage = function(imgid,matrices){
    NU.refl.priv.clas.CopiedImages.apply(this, arguments);
    this.matrices=matrices;  
};
NU.refl.priv.clas.CellRegionImage.prototype = new NU.refl.priv.clas.CopiedImages();


NU.refl.priv.clas.CellRegionImage.prototype.getTranforms=function(){
    var r,i;
    var cellstructure=this.matrices;
    r=[];
    for(i=0;i<cellstructure.length;i++){
	r[i]=this.getMatrixString(cellstructure[i]);
    }
    return r;
}





NU.refl.priv.cons.WPGTYPE=[[],
			   ["p3","p3m1","p6","p4","p4m","p4g","p31m"],
			   ["pm","pg","cm","pmm","pmg","pgg","cmm"],
			   ["p1","p2"]
			   ];

/* ** */
NU.refl.priv.clas.WPG = function(type,width,height,skew){
    this.basedata=NU.refl.priv.cons.WPG[type];
    this.width=width;
    this.height=width;
    this.skew=0;
    if(type=="p1"||type=="p2"){
	if(height){
	    this.height=height;
	}
	if(skew>=0 && skew <1){
	    this.skew=skew;
	}
    }
    if(type=="pm"||type=="pg"||type=="cm"||type=="pmm"||
       type=="pmg"||type=="pgg"||type=="cmm"){
	if(height){
	    this.height=height;
	}
    }
    /** (type=="p3" || type=="p3m1" || type=="p6" || type=="p4" ||
	type=="p4m" || type=="p4g" || type=="p31m") **/
};


NU.refl.priv.clas.WPG.prototype.getCell=function(){
    var r;
    r=[];
    r[0]=this.basedata.cell[0]*this.width*(1-this.skew);
    r[1]=this.basedata.cell[1]*this.width*(1-this.skew)+this.basedata.cell[2]*this.height*this.skew;
    r[2]=this.basedata.cell[2]*this.height;
    return r;
}
NU.refl.priv.clas.WPG.prototype.getFundamentalDomain=function(){
    var i,r;
    r=[];
    for(i=0;i<this.basedata.fundamentaldomain.length;i++){
	r[i]=
	    [
		this.basedata.fundamentaldomain[i][0]*(1-this.skew)+this.basedata.fundamentaldomain[i][1]*this.skew,
		this.basedata.fundamentaldomain[i][1]
	    ];
    }
    return r;
};
NU.refl.priv.clas.WPG.prototype.getCellStructure=function(){
    var i,r;
    r=[];
    for(i=0;i<this.basedata.cellstructure.length;i++){
	r[i]=
	    [
		this.basedata.cellstructure[i][0],
		this.basedata.cellstructure[i][1]*this.height/this.width,
		this.basedata.cellstructure[i][2]*this.width/this.height,
		this.basedata.cellstructure[i][3],
		this.basedata.cellstructure[i][4]*this.width,
		this.basedata.cellstructure[i][5]*this.height
	    ];
    }
    return r;
};


NU.refl.priv.cons.WPG = {
    "p1": {
	"cell":[1,0,1],
	"fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0]
	]
    },
    "p2": {
	"cell":[1,0,2],
	"fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [-1,0,0,-1,1,0]
	]
    },
    "pm": {
	"cell":[1,0,2],
	"fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [1,0,0,-1,0,0],
	]
    },
    "pg": {
	"cell":[2,0,1],
	"fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [1,0,0,-1,-1,1]
	]
    },
    "cm": {
	"cell":[1,0.5,1],
	"fundamentaldomain":[ [0,0],[1,0],[0.5,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [1,0,0,-1,0,0]
	]
    },
    "pmm": {
	"cell":[2,0,2],
	"fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [1,0,0,-1,0,0],
	    [-1,0,0,-1,0,0],
	    [-1,0,0,1,0,0]
	]
    },
    "pmg": {
	"cell":[2,0,2],
	"fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [1,0,0,-1,0,0],
	    [-1,0,0,-1,0,1],
	    [-1,0,0,1,0,-1]
	]
    },
    "pgg": {
	"cell":[1,0,2],
	"fundamentaldomain":[ [0,0],[1,0],[0.5,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [-1,0,0,-1,1,0],
	    [1,0,0,-1,-0.5,1],
	    [-1,0,0,1,0.5,1]
	]
    },
    "cmm": {
	"cell":[2,1,1],
	"fundamentaldomain":[ [0,0],[1,0],[0,1]],
	"cellstructure":[
	    [1,0,0,1,0,0],
	    [1,0,0,-1,0,0],
	    [-1,0,0,-1,0,0],
	    [-1,0,0,1,0,0]
	]
    }
};

/**  */
NU.refl.priv.cons.WPG.p3 = {
    "cell":[2,1,Math.sqrt(3)/3],
    "fundamentaldomain":[ [0,0],[2/3,0],[1,Math.sqrt(3)/3],[1/3,Math.sqrt(3)/3]],
    "cellstructure":[]
};
var i;
for(i=0;i<3;i++){
    NU.refl.priv.cons.WPG.p3.cellstructure[i]=[Math.cos(2*i*Math.PI/3),Math.sin(2*i*Math.PI/3),Math.cos(2*i*Math.PI/3+Math.PI/2),Math.sin(2*i*Math.PI/3+Math.PI/2),0,0];
}




/* ** */
NU.refl.priv.cons.WPG.p3m1 = {
    "cell":[3,3/2,Math.sqrt(3)/2],
    "fundamentaldomain":[ [0,0],[1,0],[0.5,Math.sqrt(3)/2]],
    "cellstructure":[]
};
var i;
for(i=0;i<3;i++){
    NU.refl.priv.cons.WPG.p3m1.cellstructure[i]=[Math.cos(2*i*Math.PI/3),Math.sin(2*i*Math.PI/3),Math.cos(2*i*Math.PI/3+Math.PI/2),Math.sin(2*i*Math.PI/3+Math.PI/2),0,0];
}
for(i=0;i<3;i++){
    NU.refl.priv.cons.WPG.p3m1.cellstructure[3+i]=[Math.cos(2*i*Math.PI/3),Math.sin(2*i*Math.PI/3),Math.cos(2*i*Math.PI/3-Math.PI/2),Math.sin(2*i*Math.PI/3-Math.PI/2),0,0];
}


/**  */
NU.refl.priv.cons.WPG.p31m = {
    "cell":[2,1,1/Math.sqrt(3)*3],
    "fundamentaldomain":[ [0,0],[1,0],[1,1/Math.sqrt(3)]],
    "cellstructure":[]
};
var i;
for(i=0;i<6;i++){
    NU.refl.priv.cons.WPG.p31m.cellstructure[i]=[Math.cos(i*Math.PI/3),Math.sin(i*Math.PI/3),Math.cos(i*Math.PI/3+Math.PI/2),Math.sin(i*Math.PI/3+Math.PI/2),0,0];
}
for(i=0;i<6;i++){
    NU.refl.priv.cons.WPG.p31m.cellstructure[i+6]=[Math.cos(i*Math.PI/3-Math.PI/3),Math.sin(i*Math.PI/3-Math.PI/3),Math.cos(i*Math.PI/3+Math.PI/2+2*Math.PI/3),Math.sin(i*Math.PI/3+Math.PI/2+2*Math.PI/3),0,0];
}


/* ** */
NU.refl.priv.cons.WPG.p6 = {
    "cell":[3,3/2,Math.sqrt(3)/2],
    "fundamentaldomain":[ [0,0],[1,0],[0.5,Math.sqrt(3)/2]],
    "cellstructure":[]
};
var i;
for(i=0;i<6;i++){
    NU.refl.priv.cons.WPG.p6.cellstructure[i]=[Math.cos(i*Math.PI/3),Math.sin(i*Math.PI/3),Math.cos(i*Math.PI/3+Math.PI/2),Math.sin(i*Math.PI/3+Math.PI/2),0,0];
}

/* ** */
NU.refl.priv.cons.WPG.p4 = {
    "cell":[2,0,2],
    "fundamentaldomain":[ [0,0],[1,0],[1,1],[0,1]],
    "cellstructure":[]
};
var i;
for(i=0;i<4;i++){
    NU.refl.priv.cons.WPG.p4.cellstructure[i]=[Math.cos(i*Math.PI/2),Math.sin(i*Math.PI/2),Math.cos(i*Math.PI/2+Math.PI/2),Math.sin(i*Math.PI/2+Math.PI/2),0,0];
}


/* ** */
NU.refl.priv.cons.WPG.p4m = {
    "cell":[2,0,2],
    "fundamentaldomain":[ [0,0],[1,0],[1,1]],
    "cellstructure":[]
};
var i;
for(i=0;i<4;i++){
    NU.refl.priv.cons.WPG.p4m.cellstructure[i]=[Math.cos(i*Math.PI/2),Math.sin(i*Math.PI/2),Math.cos(i*Math.PI/2+Math.PI/2),Math.sin(i*Math.PI/2+Math.PI/2),0,0];
}
for(i=0;i<4;i++){
    NU.refl.priv.cons.WPG.p4m.cellstructure[4+i]=[Math.cos(i*Math.PI/2),Math.sin(i*Math.PI/2),Math.cos(i*Math.PI/2-Math.PI/2),Math.sin(i*Math.PI/2-Math.PI/2),0,0];
}


/* ** */
NU.refl.priv.cons.WPG.p4g = {
    "cell":[2,0,2],
    "fundamentaldomain":[ [0,0],[1,0],[0,1]],
    "cellstructure":[]
};
var i;
for(i=0;i<4;i++){
    NU.refl.priv.cons.WPG.p4g.cellstructure[i]=[Math.cos(i*Math.PI/2),Math.sin(i*Math.PI/2),Math.cos(i*Math.PI/2+Math.PI/2),Math.sin(i*Math.PI/2+Math.PI/2),0,0];
}
for(i=0;i<4;i++){
    NU.refl.priv.cons.WPG.p4g.cellstructure[i+4]=[Math.cos(i*Math.PI/2+Math.PI/2),Math.sin(i*Math.PI/2+Math.PI/2),Math.cos(i*Math.PI/2),Math.sin(i*Math.PI/2),Math.cos(i*Math.PI/2)-Math.cos(i*Math.PI/2+Math.PI/2),Math.sin(i*Math.PI/2)-Math.sin(i*Math.PI/2+Math.PI/2)];
}

